/*
 * Decompiled with CFR 0.152.
 */
package yuku.tampilteks;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TampilTeks {
    private String text = "";
    private String isi = "";
    private String fmt = "";
    private String war = "";
    private Graphics g;
    private Font[] styleFont;
    private int fh = 0;
    private int spasiw = 0;
    private int ox;
    private int oy;
    private int scrH;

    public void setText(String html) {
        this.text = html;
        this.prosesHtml();
    }

    private void prosesHtml() {
        char f = '\u0000';
        char w = '\u0000';
        if (this.text.length() == 0) {
            this.isi = "";
            this.fmt = "";
            this.war = "";
            return;
        }
        StringBuffer isi = new StringBuffer(this.text.length());
        StringBuffer fmt = new StringBuffer(this.text.length());
        StringBuffer war = new StringBuffer(this.text.length());
        StringBuffer tag = new StringBuffer();
        int pos = 0;
        block0: do {
            char c;
            if ((c = this.text.charAt(pos)) != '<') {
                isi.append(c);
                fmt.append(f);
                war.append(w);
                continue;
            }
            while (++pos < this.text.length()) {
                String ws;
                char d = this.text.charAt(pos);
                if (d != '>') {
                    tag.append(d);
                    continue;
                }
                String tag2 = tag.toString();
                if (tag2.equalsIgnoreCase("b")) {
                    f = (char)(f | '\u0001');
                }
                if (tag2.equalsIgnoreCase("i")) {
                    f = (char)(f | 2);
                }
                if (tag2.equalsIgnoreCase("u")) {
                    f = (char)(f | 4);
                }
                if (tag2.equalsIgnoreCase("/b")) {
                    f = (char)(f & 0xFFFFFFFE);
                }
                if (tag2.equalsIgnoreCase("/i")) {
                    f = (char)(f & 0xFFFFFFFD);
                }
                if (tag2.equalsIgnoreCase("/u")) {
                    f = (char)(f & 0xFFFFFFFB);
                }
                if (tag2.equalsIgnoreCase("br")) {
                    isi.append('\n');
                    fmt.append(f);
                    war.append(c);
                }
                if ((tag2.startsWith("w") || tag2.startsWith("W")) && (ws = tag2.substring(1)).length() == 3) {
                    w = (char)Integer.parseInt(ws, 16);
                }
                if (tag2.equalsIgnoreCase("/w")) {
                    w = '\u0000';
                }
                tag = new StringBuffer();
                continue block0;
            }
        } while (++pos < this.text.length());
        this.isi = isi.toString();
        this.fmt = fmt.toString();
        this.war = war.toString();
    }

    public String getText() {
        return this.text;
    }

    public void paint(Graphics g, int x, int y, int w, int h) {
        this.g = g;
        this.ox = x;
        this.oy = y;
        this.scrH = h;
        this.prepareFont();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, w, h);
        int px = 0;
        int py = 0;
        int bufs = 0;
        int bufe = 0;
        g.setColor(0);
        while (true) {
            char c;
            boolean beres = false;
            if (bufe >= this.isi.length()) {
                c = '\u0000';
                beres = true;
            } else {
                c = this.isi.charAt(bufe);
            }
            if (c == ' ' || c == '\n' || beres) {
                int wperlu = this.substringWidth(bufs, bufe - bufs);
                if (px == 0) {
                    this.drawSubstring(bufs, bufe - bufs + (c == ' ' ? 1 : 0), px, py, 20);
                    px += wperlu + this.spasiw;
                    bufs = ++bufe;
                } else {
                    if (px + wperlu > w) {
                        px = 0;
                        py += this.fh;
                    }
                    this.drawSubstring(bufs, bufe - bufs + (c == ' ' ? 1 : 0), px, py, 20);
                    px += wperlu + this.spasiw;
                    bufs = ++bufe;
                }
                if (beres) break;
                if (c != '\n') continue;
                py += this.fh;
                px = 0;
                continue;
            }
            ++bufe;
        }
    }

    private int substringWidth(int dari, int len) {
        int ret = 0;
        int pos = dari;
        while (pos < dari + len) {
            char f = this.fmt.charAt(pos);
            char c = this.isi.charAt(pos);
            ret += this.getStyleFont(f).charWidth(c);
            ++pos;
        }
        return ret;
    }

    private void prepareFont() {
        int boldw;
        if (this.styleFont != null) {
            return;
        }
        this.styleFont = new Font[8];
        Font coba = Font.getDefaultFont();
        int h = coba.getHeight();
        if (h > 15) {
            coba = Font.getFont((int)0, (int)0, (int)8);
        } else if (h < 12) {
            coba = Font.getFont((int)0, (int)0, (int)16);
        }
        this.fh = coba.getHeight();
        this.spasiw = coba.charWidth(' ');
        int i = 0;
        while (i <= 7) {
            this.styleFont[i] = Font.getFont((int)coba.getFace(), (int)i, (int)coba.getSize());
            ++i;
        }
        int normw = this.styleFont[0].stringWidth("aiUE_");
        if (normw == (boldw = this.styleFont[1].stringWidth("aiUE_"))) {
            this.styleFont[1] = this.styleFont[5];
            this.styleFont[3] = this.styleFont[7];
        }
    }

    private void drawSubstring(int offset, int len, int x, int y, int anchor) {
        int ybetul = y - this.oy;
        if (ybetul + this.fh < 0 || ybetul > this.scrH) {
            return;
        }
        int pos = offset;
        while (pos < offset + len) {
            char f = this.fmt.charAt(pos);
            char c = this.isi.charAt(pos);
            char w = this.war.charAt(pos);
            Font font = this.getStyleFont(f);
            this.g.setFont(font);
            this.g.setColor((w & 0xF00) * 4352 + (w & 0xF0) * 272 + (w & 0xF) * 17);
            this.g.drawChar(c, x - this.ox, y - this.oy, anchor);
            x += font.charWidth(c);
            ++pos;
        }
    }

    private Font getStyleFont(int style) {
        this.prepareFont();
        return this.styleFont[style];
    }
}

